<?php
// Asegurarse que ImageMagick esté habilitado en el servidor
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['imagen'])) {
    $archivo = $_FILES['imagen']['tmp_name'];
    $nombreOriginal = $_FILES['imagen']['name'];
    $extension = strtolower(pathinfo($nombreOriginal, PATHINFO_EXTENSION));

    if (!in_array($extension, ['jpg', 'jpeg', 'png'])) {
        die("Formato no permitido. Solo JPG o PNG.");
    }

    // Directorio destino
    $destino = __DIR__;

    // Crear imagen temporal cuadrada (recorte centrado)
    $temp = "$destino/temp_square.png";
    exec("convert $archivo -resize 512x512^ -gravity center -extent 512x512 $temp");

    // Crear versiones finales
    $tamaños = [
        180 => 'icon-180.png',
        192 => 'icon-192.png',
        512 => 'icon-512.png'
    ];

    foreach ($tamaños as $px => $nombreFinal) {
        exec("convert $temp -resize {$px}x{$px} $destino/$nombreFinal");
    }

    unlink($temp);
    echo "Íconos generados correctamente.";
    echo "<br><a href='index.php'>Volver</a>";
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Subir ícono cuadrado</title>
</head>
<body>
    <h2>Subir una imagen para generar íconos (1:1)</h2>
    <form method="post" enctype="multipart/form-data">
        <input type="file" name="imagen" required>
        <br><br>
        <button type="submit">Subir y generar íconos</button>
    </form>
</body>
</html>